CREATE OR REPLACE FORCE VIEW w83b.w83bvistadatosdocumentacion (numero,
                                                               tipo,
                                                               centro,
                                                               fechaeleccion,
                                                               fechaentrada,
                                                               fechaimpugnacion,
                                                               fechaeleccionacta,
                                                               vers,
                                                               documentos
                                                              )
AS
   SELECT   numero, tipo, centro, fechaeleccion, fechaentrada,
            fechaimpugnacion, fechaeleccionacta, vers, documentos
       FROM (
             --ACTAS
             SELECT   (   acta.c_territ_016
                       || '/'
                       || acta.ano_acta_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                  1, '00000' || TO_CHAR (acta.n_acta_016),
                                  2, '0000' || TO_CHAR (acta.n_acta_016),
                                  3, '000' || TO_CHAR (acta.n_acta_016),
                                  4, '00' || TO_CHAR (acta.n_acta_016),
                                  5, '0' || TO_CHAR (acta.n_acta_016),
                                  TO_CHAR (acta.n_acta_016)
                                 )
                      ) AS numero,
                      'ACTA' AS tipo, acta.id_centro_016 centro,
                      TO_CHAR (acta.f_elecc_016, 'dd/MM/yyyy') fechaeleccion,
                      TO_CHAR (acta.f_entra_016,
                               'dd/MM/yyyy') AS fechaentrada,
                      '' AS fechaimpugnacion,
                      acta.f_elecc_016 AS fechaeleccionacta,
                      acta.version_016 vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_020
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_020
                                              || ','
                                              || doc.num_reg_020
                                              || ','
                                              || doc.id_doc_020
                                              || ',ACTA'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b16t00 acta LEFT OUTER JOIN w83b20t00 doc
                      ON acta.ano_acta_016 = doc.ano_acta_020
                    AND acta.n_acta_016 = doc.n_acta_020
                    AND acta.c_territ_016 = doc.c_territ_020
                    AND acta.version_016 = doc.version_020
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_020 = tipos.idtp_doc_069
                    AND doc.c_fase_020 = tipos.c_fase_069
                    AND doc.c_tram_020 = tipos.c_tram_069
                WHERE acta.version_016 =
                         (SELECT MAX (t16temp.version_016)
                            FROM w83b16s00 t16temp
                           WHERE t16temp.ano_acta_016 = acta.ano_acta_016
                             AND t16temp.n_acta_016 = acta.n_acta_016
                             AND t16temp.c_territ_016 = acta.c_territ_016
                             AND t16temp.validada_016 = '1')
             GROUP BY acta.ano_acta_016,
                      acta.n_acta_016,
                      acta.c_territ_016,
                      acta.version_016,
                      acta.id_centro_016,
                      acta.f_elecc_016,
                      acta.f_entra_016
             UNION
             --PREAVISOS
             SELECT   (   preaviso.c_territ_037
                       || '/'
                       || preaviso.ano_preaviso_037
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (preaviso.n_preaviso_037)),
                                  1, '00000'
                                   || TO_CHAR (preaviso.n_preaviso_037),
                                  2, '0000'
                                   || TO_CHAR (preaviso.n_preaviso_037),
                                  3, '000'
                                   || TO_CHAR (preaviso.n_preaviso_037),
                                  4, '00' || TO_CHAR (preaviso.n_preaviso_037),
                                  5, '0' || TO_CHAR (preaviso.n_preaviso_037),
                                  TO_CHAR (preaviso.n_preaviso_037)
                                 )
                      ) AS numero,
                      'PREAVISO' AS tipo,
                                         --se busca el centro de trabajo del propio preaviso
                                         preaviso.id_centro_037,
                      TO_CHAR (preaviso.f_elecc_037,
                               'dd/MM/yyyy'
                              ) fechaeleccion,
                      TO_CHAR (preaviso.f_entra_037,
                               'dd/MM/yyyy'
                              ) AS fechaentrada,
                      '' AS fechaimpugnacion,
                      CASE
                         WHEN preaviso.f_elecc_037 IS NOT NULL
                            THEN preaviso.f_elecc_037
                         ELSE preaviso.f_entra_037
                      END fechaeleccionacta,
                      (SELECT MAX (version_016)
                         FROM w83b16s00 actas
                        WHERE actas.n_acta_016 = preaviso.n_acta_037
                          AND actas.ano_acta_016 = preaviso.ano_acta_037
                          AND actas.c_territ_016 = preaviso.c_territ_037
                          AND validada_016 = 1) vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_038
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_038
                                              || ','
                                              || doc.num_reg_038
                                              || ','
                                              || doc.id_doc_038
                                              || ',PREAVISO'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b37t00 preaviso LEFT OUTER JOIN w83b38t00 doc
                      ON preaviso.c_territ_037 = doc.c_territ_038
                    AND preaviso.ano_preaviso_037 = doc.ano_preaviso_038
                    AND preaviso.n_preaviso_037 = doc.n_preaviso_038
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_038 = tipos.idtp_doc_069
                    AND doc.c_fase_038 = tipos.c_fase_069
                    AND doc.c_tram_038 = tipos.c_tram_069
             GROUP BY preaviso.c_territ_037,
                      preaviso.ano_preaviso_037,
                      preaviso.n_preaviso_037,
                      preaviso.id_centro_037,
                      preaviso.f_elecc_037,
                      preaviso.f_entra_037,
                      preaviso.n_acta_037,
                      preaviso.ano_acta_037,
                      preaviso.c_territ_037
             UNION
             --INCIDENCIAS
             SELECT   (   incidencia.c_territ_061
                       || '/'
                       || incidencia.ano_incid_061
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (incidencia.n_incid_061)),
                                  1, '00000'
                                   || TO_CHAR (incidencia.n_incid_061),
                                  2, '0000'
                                   || TO_CHAR (incidencia.n_incid_061),
                                  3, '000' || TO_CHAR (incidencia.n_incid_061),
                                  4, '00' || TO_CHAR (incidencia.n_incid_061),
                                  5, '0' || TO_CHAR (incidencia.n_incid_061),
                                  TO_CHAR (incidencia.n_incid_061)
                                 )
                      ) AS numero,
                      'INCIDENCIA' AS tipo,
                      (SELECT act.id_centro_016
                         FROM w83b16t00 act INNER JOIN w83b61t00 inc
                              ON act.ano_acta_016 = inc.ano_acta_061
                            AND act.n_acta_016 = inc.n_acta_061
                            AND act.c_territ_016 = inc.c_territ_061
                        --hay que sacar todas las incidencias, conrrespondan con el acta validada o no
                        --AND act.version_016 = inc.version_acta_061
                       WHERE  incidencia.ano_incid_061 = inc.ano_incid_061
                          AND incidencia.n_incid_061 = inc.n_incid_061
                          AND incidencia.c_territ_061 = inc.c_territ_061
                          AND act.version_016 =
                                 (SELECT MAX (t16temp.version_016)
                                    FROM w83b16s00 t16temp
                                   WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                     AND t16temp.n_acta_016 = act.n_acta_016
                                     AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                                                              --AND t16temp.validada_016 = '1'
                                 )) centro,
                      --sacamos su fecha
                      '' fechaeleccion,
                      TO_CHAR (incidencia.f_entrada_061,
                               'dd/MM/yyyy'
                              ) fechaentrada,
                      '' fechaimpugnacion,
                      (SELECT act.f_elecc_016
                         FROM w83b16t00 act INNER JOIN w83b61t00 inc
                              ON act.ano_acta_016 =
                                        inc.ano_acta_061
                            AND act.n_acta_016 = inc.n_acta_061
                            AND act.c_territ_016 = inc.c_territ_061
                            AND act.version_016 = inc.version_acta_061
                        WHERE incidencia.ano_incid_061 = inc.ano_incid_061
                          AND incidencia.n_incid_061 = inc.n_incid_061
                          AND incidencia.c_territ_061 = inc.c_territ_061
                                                                        /*AND act.version_016 =
                                                                               (SELECT MAX (t16temp.version_016)
                                                                                  FROM w83b16s00 t16temp
                                                                                 WHERE t16temp.ano_acta_016 =
                                                                                                        act.ano_acta_016
                                                                                   AND t16temp.n_acta_016 =
                                                                                                          act.n_acta_016
                                                                                   AND t16temp.c_territ_016 =
                                                                                                        act.c_territ_016
                                                                                                                        --AND t16temp.validada_016 = '1'
                                                                               )*/
                      ) AS fechaeleccionacta,
                      0 vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_064
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_064
                                              || ','
                                              || doc.num_reg_064
                                              || ','
                                              || doc.id_doc_064
                                              || ',INCIDENCIA'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b61t00 incidencia LEFT OUTER JOIN w83b64t00 doc
                      ON incidencia.c_territ_061 = doc.c_territ_064
                    AND incidencia.ano_incid_061 = doc.ano_incid_064
                    AND incidencia.n_incid_061 = doc.n_incid_064
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_064 = tipos.idtp_doc_069
                    AND doc.c_tram_064 = tipos.c_fase_069
                    AND doc.c_tram_064 = tipos.c_tram_069
                --en principio no se mira si estan validadas o no
                --no se muestran las de tipo subsanacion
             --ahora puede ser de cualquier tipo WHERE    incidencia.tp_incidencia_061 <> 7
             GROUP BY incidencia.c_territ_061,
                      incidencia.ano_incid_061,
                      incidencia.n_incid_061,
                      incidencia.f_entrada_061
             UNION
             --IMPUGNACIONES
             SELECT   (   impugnacion.c_territ_033
                       || '/'
                       || impugnacion.ano_impug_033
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (impugnacion.n_impug_033)),
                                  1, '00000'
                                   || TO_CHAR (impugnacion.n_impug_033),
                                  2, '0000'
                                   || TO_CHAR (impugnacion.n_impug_033),
                                  3, '000'
                                   || TO_CHAR (impugnacion.n_impug_033),
                                  4, '00' || TO_CHAR (impugnacion.n_impug_033),
                                  5, '0' || TO_CHAR (impugnacion.n_impug_033),
                                  TO_CHAR (impugnacion.n_impug_033)
                                 )
                      ) AS numero,
                      'IMPUGNACION' AS tipo,
                      CASE
                         --es de un acta
                      WHEN impugnacion.n_acta_033 > 0
                            THEN (SELECT act.id_centro_016
                                    FROM w83b16t00 act INNER JOIN w83b33t00 imp
                                         ON act.ano_acta_016 =
                                                      imp.ano_acta_033
                                       AND act.n_acta_016 = imp.n_acta_033
                                       AND act.c_territ_016 = imp.c_territ_033
                                       AND act.version_016 = imp.version_033
                                   WHERE impugnacion.ano_impug_033 =
                                                             imp.ano_impug_033
                                     AND impugnacion.n_impug_033 =
                                                               imp.n_impug_033
                                     AND impugnacion.c_territ_033 =
                                                              imp.c_territ_033
                                     AND act.version_016 =
                                            (SELECT MAX (t16temp.version_016)
                                               FROM w83b16s00 t16temp
                                              WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                                AND t16temp.n_acta_016 =
                                                                act.n_acta_016
                                                AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                                AND t16temp.validada_016 = '1'))
                         --es de un preaviso
                      ELSE (SELECT pre.id_centro_037
                              FROM w83b37t00 pre INNER JOIN w83b33t00 imp
                                   ON pre.ano_preaviso_037 =
                                                          imp.ano_preaviso_033
                                 AND pre.n_preaviso_037 = imp.n_preaviso_033
                                 AND pre.c_territ_037 = imp.c_territ_033
                             WHERE impugnacion.ano_impug_033 =
                                                             imp.ano_impug_033
                               AND impugnacion.n_impug_033 = imp.n_impug_033
                               AND impugnacion.c_territ_033 = imp.c_territ_033)
                      END centro,        
                      --sacamos sus fechas propias
                      '' fechaeleccion, '' fechaentrada,
                      TO_CHAR (impugnacion.f_impug_033,
                               'dd/MM/yyyy'
                              ) fechaimpugnacion,
                      CASE
                         --es de un acta
                      WHEN impugnacion.n_acta_033 > 0
                            THEN (SELECT act.f_elecc_016
                                    FROM w83b16t00 act INNER JOIN w83b33t00 imp
                                         ON act.ano_acta_016 =
                                                       imp.ano_acta_033
                                       AND act.n_acta_016 = imp.n_acta_033
                                       AND act.c_territ_016 = imp.c_territ_033
                                       AND act.version_016 = imp.version_033
                                   WHERE impugnacion.ano_impug_033 =
                                                             imp.ano_impug_033
                                     AND impugnacion.n_impug_033 =
                                                               imp.n_impug_033
                                     AND impugnacion.c_territ_033 =
                                                              imp.c_territ_033
                                     AND act.version_016 =
                                            (SELECT MAX (t16temp.version_016)
                                               FROM w83b16s00 t16temp
                                              WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                                AND t16temp.n_acta_016 =
                                                                act.n_acta_016
                                                AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                                AND t16temp.validada_016 = '1'))
                         --es de un preaviso
                      ELSE CASE
                         WHEN (SELECT prea.f_elecc_037
                                 FROM w83b16t00 act INNER JOIN w83b37t00 prea
                                      ON act.ano_acta_016 = prea.ano_acta_037
                                    AND act.n_acta_016 = prea.n_acta_037
                                    AND act.c_territ_016 = prea.c_territ_037
                                -- AND act.version_016 = prea.
                               WHERE  impugnacion.ano_preaviso_033 =
                                                         prea.ano_preaviso_037
                                  AND impugnacion.n_preaviso_033 =
                                                           prea.n_preaviso_037
                                  AND impugnacion.c_territ_033 =
                                                             prea.c_territ_037
                                  AND act.version_016 =
                                         (SELECT MAX (t16temp.version_016)
                                            FROM w83b16s00 t16temp
                                           WHERE t16temp.ano_acta_016 =
                                                              act.ano_acta_016
                                             AND t16temp.n_acta_016 =
                                                                act.n_acta_016
                                             AND t16temp.c_territ_016 =
                                                              act.c_territ_016
                                             AND t16temp.validada_016 = '1')) IS NOT NULL
                            THEN (SELECT prea.f_elecc_037
                                    FROM /*w83b16t00 act INNER JOIN*/ w83b37t00 prea
                                         /*ON act.ano_acta_016 =
                                                            prea.ano_acta_037
                                       AND act.n_acta_016 = prea.n_acta_037
                                       AND act.c_territ_016 =
                                                            prea.c_territ_037*/
                                   -- AND act.version_016 = prea.
                                  WHERE  impugnacion.ano_preaviso_033 =
                                                         prea.ano_preaviso_037
                                     AND impugnacion.n_preaviso_033 =
                                                           prea.n_preaviso_037
                                     AND impugnacion.c_territ_033 =
                                                             prea.c_territ_037
                                                                              /*AND act.version_016 =
                                                                                     (SELECT MAX (t16temp.version_016)
                                                                                        FROM w83b16s00 t16temp
                                                                                       WHERE t16temp.ano_acta_016 =
                                                                                                      act.ano_acta_016
                                                                                         AND t16temp.n_acta_016 =
                                                                                                        act.n_acta_016
                                                                                         AND t16temp.c_territ_016 =
                                                                                                      act.c_territ_016
                                                                                         AND t16temp.validada_016 =
                                                                                                                   '1')*/
                                )
                         ELSE (SELECT prea.f_entra_037
                                 FROM /*w83b16t00 act INNER JOIN*/ w83b37t00 prea
                                      /*ON act.ano_acta_016 =
                                                         prea.ano_acta_037
                                    AND act.n_acta_016 = prea.n_acta_037
                                    AND act.c_territ_016 =
                                                         prea.c_territ_037*/
                                -- AND act.version_016 = prea.
                               WHERE  impugnacion.ano_preaviso_033 =
                                                         prea.ano_preaviso_037
                                  AND impugnacion.n_preaviso_033 =
                                                           prea.n_preaviso_037
                                  AND impugnacion.c_territ_033 =
                                                             prea.c_territ_037
                                                                              /*AND act.version_016 =
                                                                                     (SELECT MAX (t16temp.version_016)
                                                                                        FROM w83b16s00 t16temp
                                                                                       WHERE t16temp.ano_acta_016 =
                                                                                                      act.ano_acta_016
                                                                                         AND t16temp.n_acta_016 =
                                                                                                        act.n_acta_016
                                                                                         AND t16temp.c_territ_016 =
                                                                                                      act.c_territ_016
                                                                                         AND t16temp.validada_016 =
                                                                                                                   '1')*/
                      )
                      END
                      END padre,
                      impugnacion.version_033 vers,
                      RTRIM
                         (XMLAGG (XMLELEMENT (e,
                                                 doc.nomb_docu_041
                                              || ','
                                              || tipos.desc_cas_069
                                              || ','
                                              || tipos.desc_eus_069
                                              || ','
                                              || doc.f_reg_041
                                              || ','
                                              || doc.num_reg_041
                                              || ','
                                              || doc.id_doc_041
                                              || ',IMPUGNACION'
                                              || '#'
                                             )
                                 ).EXTRACT ('//text()'),
                          '#'
                         ) documentos
                 FROM w83b33t00 impugnacion LEFT OUTER JOIN w83b41t00 doc
                      ON impugnacion.c_territ_033 = doc.c_territ_041
                    AND impugnacion.ano_impug_033 = doc.ano_impug_041
                    AND impugnacion.n_impug_033 = doc.n_impug_041
                      LEFT OUTER JOIN w83b69t00 tipos
                      ON doc.tp_doc_041 = tipos.idtp_doc_069
                    AND doc.c_fase_041 = tipos.c_fase_069
                    AND doc.c_tram_041 = tipos.c_tram_069
             GROUP BY impugnacion.c_territ_033,
                      impugnacion.ano_impug_033,
                      impugnacion.n_impug_033,
                      impugnacion.version_033,
                      impugnacion.n_acta_033,
                      impugnacion.f_impug_033,
                      impugnacion.ano_preaviso_033,
                      impugnacion.n_preaviso_033)
   ORDER BY numero;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW w83b.comprobardatosusuario (dni_001,
                                                         nombre_001,
                                                         apel1_001,
                                                         apel2_001,
                                                         c_territ_051,
                                                         calle_051,
                                                         num_051,
                                                         piso_051,
                                                         letra_051,
                                                         cp_051,
                                                         localidad_051,
                                                         ds_o,
                                                         telefono1_051,
                                                         telefono2_o51,
                                                         fax_051,
                                                         reg_manual_051,
                                                         nummod_051,
                                                         nummodsal_051
                                                        )
AS
   SELECT usu.dni_001, nombre_001, apel1_001, apel2_001, deleg.c_territ_051,
          deleg.calle_051, deleg.num_051, deleg.piso_051, deleg.letra_051,
          deleg.cp_051, deleg.localidad_051, municipio.ds_o,
          deleg.telefono1_051, deleg.telefono2_o51, deleg.fax_051,
          deleg.reg_manual_051, deleg.nummod_051, deleg.nummodsal_051
     FROM w83b01s00 usu LEFT OUTER JOIN w83b51s00 deleg
          ON usu.c_territ_001 = deleg.c_territ_051
          LEFT OUTER JOIN t17i.t17_municipio municipio
          ON deleg.localidad_051 = municipio.ID
        AND deleg.c_territ_051 = municipio.provincia_id
    WHERE (   usu.f_baja_001 IS NULL
           OR (    usu.f_baja_001 IS NOT NULL
               AND TO_DATE (SYSDATE, 'dd/MM/yyyy') <
                                        TO_DATE (usu.f_baja_001, 'dd/MM/yyyy')
              )
          );
/

